% Modelo 4 Tanques con datos de planta real suministrados el 28/06/07

function [sal]=CuatroTanquesModel(ent)

global plant;

v1=ent(1);
v2=ent(2);
h1=ent(3);
h2=ent(4);
h3=ent(5);
h4=ent(6);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%    PARAMETROS PLANTA      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
a1=plant.a(1); %m^2
a2=plant.a(2); %m^2
a3=plant.a(3); %m^2
a4=plant.a(4); %m^2

K1=a1/plant.A*sqrt(2*plant.g);
K2=a2/plant.A*sqrt(2*plant.g);
K3=a3/plant.A*sqrt(2*plant.g);
K4=a4/plant.A*sqrt(2*plant.g);

K3g=a3/plant.A*sqrt(2*plant.g);
K4g=a4/plant.A*sqrt(2*plant.g);

K5=plant.g1/plant.A;
K6=plant.g2/plant.A;

K7=(1-plant.g2)/plant.A;
K8=(1-plant.g1)/plant.A;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   ECUACIONES PLANTA       %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

h1p=-K1*sqrt(h1)+K3g*sqrt(h3)+K5*v1;

h2p=-K2*sqrt(h2)+K4g*sqrt(h4)+K6*v2;

h3p=-K3*sqrt(h3)+             K7*v2;

h4p=-K4*sqrt(h4)+             K8*v1;



sal(1)=h1p;
sal(2)=h2p;
sal(3)=h3p;
sal(4)=h4p;